<?php

// Base Class
class Personne {
    protected $nom;
    protected $prenom;
    protected $age;
    protected $sexe;
    protected $pointsDeVie;

    // 
    public function __construct($nom, $prenom, $age, $sexe, $pointsDeVie = 100) {
        $this->nom = $nom;
        $this->prenom = $prenom;
        $this->age = $age;
        $this->sexe = $sexe;
        $this->pointsDeVie = $pointsDeVie;
    }

    // Getter for name
    public function getNom() {
        return $this->nom;
    }

    public function getPrenom() {
        return $this->prenom;
    }

    // Presentation method
    public function sePresenter() {
        return "Bonjour, je m'appelle {$this->prenom} {$this->nom}, j'ai {$this->age} ans.";
    }

    // Aging method
    public function vieillir() {
        $this->age++;
    }

    // Default action
    public function agir() {
        echo "Mais que voulez-vous que je fasse ?<br>";
    }
}

// Operator Class
class Operateur extends Personne {
    private $metier;
    private $experience;

    public function __construct($nom, $prenom, $age, $sexe, $metier) {
        parent::__construct($nom, $prenom, $age, $sexe);
        $this->metier = $metier;
        $this->experience = 0; // Starts at 0
    }

    public function getMetier() {
        return $this->metier;
    }

    // Override presentation
    public function sePresenter() {
        return parent::sePresenter() . " Je suis un {$this->metier} avec {$this->experience} d'expérience.";
    }

    // Action based on job
    public function agir() {
        if ($this->metier == 'pilote') {
            echo "Le vaisseau est en train de décoller !<br>";
        } elseif ($this->metier == 'agent d\'entretien') {
            echo "Le vaisseau est nettoyé.<br>";
        } elseif ($this->metier == 'agent de maintenance') {
            echo "Le vaisseau est réparé.<br>";
        } else {
            echo "Je travaille dur à mon poste de {$this->metier}.<br>";
        }
        $this->experience += 5; // Gain 5 XP
    }
}

// Mentalist Class
class Mentaliste extends Personne {
    private $mana;

    public function __construct($nom, $prenom, $age, $sexe) {
        parent::__construct($nom, $prenom, $age, $sexe);
        $this->mana = 100; // Initialized to 100
    }

    // Override presentation
    public function sePresenter() {
        return parent::sePresenter() . " Je suis mentaliste, il me reste {$this->mana} de mana.";
    }

    // Influence action
    public function agir($personne = null) {
        // Check mana
        if ($this->mana >= 20) {
            if ($personne instanceof Personne) {
                $this->mana -= 20; // Lose 20 mana
                echo "Mentaliste : J'influence " . $personne->getNom() . "... <br>";
                $personne->agir(); // Force person to act
            } else {
                echo "Je n'ai personne à influencer.<br>";
            }
        } else {
            echo "Je n'ai pas assez de mana !<br>";
        }
    }
}
?>