<?php
require_once 'UniteSpatiale.php';

class Drone extends UniteSpatiale {
    private string $subtype; // 'kamikaze' ou 'scout'

    public function __construct(int $id, string $subtype, int $x, int $y) {
        $this->subtype = $subtype;
        
        if ($subtype === 'kamikaze') {
            $name = "Drone Kamikaze";
            $hp = 20;
        } else {
            $name = "Drone Éclaireur";
            $hp = 40;
        }

        parent::__construct($id, $name, $x, $y, $hp, 'drone');
    }

    public function jsonSerialize(): array {
        $data = parent::jsonSerialize();
        $data['subtype'] = $this->subtype;
        return $data;
    }
}
?>