<?php
require_once 'UniteSpatiale.php'; // On charge le parent

class Vaisseau extends UniteSpatiale {
    private int $energy;
    
    // Constantes pour équilibrer le jeu facilement
    private const MAX_ENERGY = 100;
    private const COST_ATTACK = 10;

    public function __construct(int $id, string $name, int $x, int $y, bool $isEnemy = false) {
        $hp = $isEnemy ? 60 : 100;
        $type = $isEnemy ? 'enemy' : 'ship';
        
        // Appelle le constructeur du parent (UniteSpatiale)
        parent::__construct($id, $name, $x, $y, $hp, $type);
        
        $this->energy = $isEnemy ? 0 : 100;
        $this->hidden = $isEnemy; 
    }

    public function regenEnergy(): void {
        $this->energy = min($this->energy + 10, self::MAX_ENERGY);
    }

    // Renvoie true si l'énergie a été consommée, false sinon
    public function consumeEnergy(int $amount): bool {
        if ($this->energy >= $amount) {
            $this->energy -= $amount;
            return true;
        }
        return false;
    }

    // On ajoute l'énergie dans le JSON pour l'affichage
    public function jsonSerialize(): array {
        $data = parent::jsonSerialize();
        $data['energy'] = $this->energy;
        return $data;
    }
}
?>