<?php
// login.php
require_once 'includes/db.php'; // Connexion centralisée

if ($_POST) {
    $login = mysqli_real_escape_string($link, $_POST['login']);
    $password = $_POST['password'];
    
    // Requête sécurisée
    $stmt = mysqli_prepare($link, "SELECT * FROM users WHERE login_user = ?");
    mysqli_stmt_bind_param($stmt, 's', $login);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if ($row = mysqli_fetch_assoc($result)) {
        // Utilisateur existant
        if (password_verify($password, $row['pwd_user'])) {
            $_SESSION['user_id'] = $row['id_user'];
            $_SESSION['username'] = $row['login_user'];
            header('Location: index.php');
            exit();
        } else {
            $message = "Mot de passe incorrect";
        }
    } else {
        // Création de compte (Register)
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $stmtIns = mysqli_prepare($link, "INSERT INTO users (login_user, pwd_user) VALUES (?, ?)");
        mysqli_stmt_bind_param($stmtIns, 'ss', $login, $hashed_password);
        
        if (mysqli_stmt_execute($stmtIns)) {
            $user_id = mysqli_insert_id($link);
            $_SESSION['user_id'] = $user_id;
            $_SESSION['username'] = $login;
            
            // Création profil joueur
            mysqli_query($link, "INSERT INTO user_profiles (user_id, ready) VALUES ($user_id, 0)");
            
            header('Location: index.php');
            exit();
        } else {
            $message = "Erreur création compte";
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Connexion - Fondation</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <div class="container"> 
        <h1>Connexion Flotte</h1>
        <form method="POST">
            <input type="text" name="login" placeholder="Identifiant" required>
            <input type="password" name="password" placeholder="Mot de passe" required>
            <button type="submit">Entrer</button>
        </form>
        <?php if (isset($message)) echo "<p style='color:red;'>$message</p>"; ?>
    </div>
</body>
</html>